'' *****************************
''
'' GPS routines
''
'' *****************************
CON

  CR = 13                              ' ASCII <CR>
  LF = 10                              ' ASCII <LF>
   serXmit   = 25                      ' Serial Transmit on mouse
   serRecv   = 24                      ' Serial Receive  on mouse
   
VAR 
   long gps_stack[16] 
   byte GPRMCb[68],GPGGAb[80],GPGSAb[80]   
   long GPRMCa[20],GPGGAa[20],GPGSAa[20]
   byte GPGSV1b[80],GPGSV2b[80],GPGSV3b[80]   
   long GPGSV1a[20],GPGSV2a[20],GPGSV3a[20]
   byte gps_buff[80],Rx,cksum
   long cog,cptr,ptr,arg,j
   long Null[1]
   long rmc_ready
   
OBJ
  uart : "FullDuplexSerial_mini"
 
PUB start : okay

'' Starts uart object (at baud specified) in a cog
'' -- returns false if no cog available

   okay := uart.start(serRecv,serXmit,0,4800)
   return cog := cognew(readNEMA,@gps_stack) + 1 

PUB readNEMA
  Null[0] := rmc_ready := 0
  repeat
   longfill(gps_buff,20,0)
   repeat while Rx <>= "$"      ' wait for the $ to insure we are starting with
     Rx := uart.rx                   '   a complete NMEA sentence 
   cptr := 0

   repeat while Rx <>= CR       '  continue to collect data until the end of the NMEA sentence 
     Rx := uart.rx              '  get character from Rx Buffer
     if Rx == ","
       gps_buff[cptr++] := 0    '  Replace the character
     else
       gps_buff[cptr++] := Rx   '  Save the character
  
   if gps_buff[2] == "R"
     if gps_buff[3] == "M"
       if gps_buff[4] == "C"
        if gps_buff[17] == "A"
          rmc_ready := 0
          copy_buffer(@GPRMCb, @GPRMCa)
                
   if gps_buff[2] == "G"
     if gps_buff[3] == "G"  
       if gps_buff[4] == "A"
'        if gps_buff[42] == "1"
           copy_buffer(@GPGGAb, @GPGGAa)

   if gps_buff[2] == "G"
     if gps_buff[3] == "S"
       if gps_buff[4] == "A"
           copy_buffer(@GPGSAb, @GPGSAa)
           
   if gps_buff[2] == "G"
     if gps_buff[3] == "S"
       if gps_buff[4] == "V"       
         if gps_buff[8] == "1"
               copy_buffer(@GPGSV1b, @GPGSV1a)               
         if gps_buff[8] == "2"
               copy_buffer(@GPGSV2b, @GPGSV2a)               
         if gps_buff[8] == "3"
               copy_buffer(@GPGSV3b, @GPGSV3a)
               rmc_ready := 1
               
pub copy_buffer ( buffer,args)
         bytemove(buffer,@gps_buff,cptr)
         ptr := buffer
         arg := 0
         repeat j from 0 to 77
          if byte[ptr] == 0
             if byte[ptr+1] == 0
                long[args][arg] := Null
             else
                long[args][arg] := ptr+1
             arg++
          ptr++
          
pub altitude
   return GPGGAa[8]
   
pub speed
   return GPRMCa[6]

pub heading
   return GPRMCa[7]

pub time
   return GPGGAa[0]
   
pub date
   return GPRMCa[8]
    
pub latitude
   return GPGGAa[1]
    
pub N_S
   return GPGGAa[2]
     
pub longitude
   return GPGGAa[3]
    
pub E_W
   return GPGGAa[4]

pub satellites
   return GPGGAa[6]
  
pub hdop
   return GPGGAa[7]
   
pub vdop
   return GPGSAa[14]

pub ready
   return rmc_ready

pub sat_id (sat)

    case sat
      1:
          return GPGSV1a[3]
      2:
          return GPGSV1a[7]
      3:
          return GPGSV1a[11]
      4:
          return GPGSV1a[15]
      5:
          return GPGSV2a[3]
      6:
          return GPGSV2a[7]
      7:
          return GPGSV2a[11]
      8:
          return GPGSV2a[15]
      9:
          return GPGSV3a[3]
      10:
          return GPGSV3a[7]
      11:
          return GPGSV3a[11]
      12:
          return GPGSV3a[15]
      other:
          return 0
          
pub sat_elevation (sat)

    case sat
      1:
          return GPGSV1a[4]
      2:
          return GPGSV1a[8]
      3:
          return GPGSV1a[12]
      4:
          return GPGSV1a[16]
      5:
          return GPGSV2a[4]
      6:
          return GPGSV2a[8]
      7:
          return GPGSV2a[12]
      8:
          return GPGSV2a[16]
      9:
          return GPGSV3a[4]
      10:
          return GPGSV3a[8]
      11:
          return GPGSV3a[12]
      12:
          return GPGSV3a[16]
      other:
          return 0
          
pub sat_azimuth (sat)

    case sat
      1:
          return GPGSV1a[5]
      2:
          return GPGSV1a[9]
      3:
          return GPGSV1a[13]
      4:
          return GPGSV1a[17]
      5:
          return GPGSV2a[5]
      6:
          return GPGSV2a[9]
      7:
          return GPGSV2a[13]
      8:
          return GPGSV2a[17]
      9:
          return GPGSV3a[5]
      10:
          return GPGSV3a[9]
      11:
          return GPGSV3a[13]
      12:
          return GPGSV3a[17]
      other:
          return 0         

pub sat_snr (sat)

    case sat
      1:
          return GPGSV1a[6]
      2:
          return GPGSV1a[10]
      3:
          return GPGSV1a[14]
      4:
          return GPGSV1a[18]
      5:
          return GPGSV2a[6]
      6:
          return GPGSV2a[10]
      7:
          return GPGSV2a[14]
      8:
          return GPGSV2a[18]
      9:
          return GPGSV3a[6]
      10:
          return GPGSV3a[10]
      11:
          return GPGSV3a[14]
      12:
          return GPGSV3a[18]
      other:
          return 0                      